<?php
/*
* $license object
*/
$license = cev_pro()->license;
?>

<div class="license_connection_section">

<?php 
$zorem_license_connected = get_option( 'zorem_license_connected', 0 );
$zorem_license_email = get_option( 'zorem_license_email', '' );
$current_url = esc_url( admin_url( '/admin.php?page=customer-email-verification-for-woocommerce&tab=add-ons' ) ); 

if ( $license->get_license_status() ) {
	?>
	<h3 class="licnese-inner-heading"><?php esc_html_e( 'Status:', 'customer-email-verification' ); ?><span class="success">Active</span></h3>
	<p><?php esc_html_e('Want to deactivate the license for any reason?', 'customer-email-verification'); ?></p>
	<form method="post" id="wc_cev_pro_addons_form" class="addons_inner_container" action="" enctype="multipart/form-data">
		<input type="hidden" name="license_key" id="license_key" value="<?php echo esc_attr( $license->get_license_key() ); ?>">
		<?php wp_nonce_field( 'wc_cev_addons_form', 'wc_cev_addons_form_nonce' ); ?>
		<input type="hidden" id="cev-pro-license-action" name="action" value="<?php echo $license->get_license_status() ? esc_html( $license->get_item_code() ) . '_license_deactivate' : esc_html( $license->get_item_code() ) . '_license_activate'; ?>" />
		<button name="save" class="button-primary woocommerce-save-button btn_green_cev" type="submit" value="Deactivate"><?php esc_html_e('Deactivate', 'customer-email-verification'); ?></button>
	</form>	
	<?php
} else if ( 1 == $zorem_license_connected && '' != $zorem_license_email ) {
	?>
	<h3 class="licnese-inner-heading"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></h3>
	<p><?php esc_html_e('Activate your license to receive automatic updates and premium support', 'customer-email-verification'); ?></p>
	<a href="https://www.zorem.com/my-account/license-activation/?product_id=<?php esc_html_e( $license->get_product_id() ); ?>&redirect_url=<?php echo urlencode( $current_url ); ?>" class="button-primary woocommerce-save-button btn_cev"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></a>
	<?php
} else {	
	?>
	<h3 class="licnese-inner-heading"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></h3>
	<p><?php esc_html_e('Activate your license to receive automatic updates and premium support.', 'customer-email-verification'); ?></p>
	<a href="https://www.zorem.com/my-account/license-activation/?product_id=<?php esc_html_e( $license->get_product_id() ); ?>&redirect_url=<?php echo urlencode( $current_url ); ?>" class="button-primary woocommerce-save-button btn_cev"><?php esc_html_e( 'Connect & Activate', 'customer-email-verification' ); ?></a>
	<?php
}
?>
</div>

