<?php
/**
 * Html code for tools tab
 */
$more_plugins = array(
	0 => array(
		'title' => 'Advanced Shipment Tracking',
		'description' => 'AST PRO provides powerful features to easily add tracking info to WooCommerce orders, automate the fulfillment workflows and keep your customers happy and informed. AST allows you to easily add tracking and fulfill your orders straight from the Orders page, while editing orders, and allows customers to view the tracking i from the View Order page.',
		'url' => 'https://www.zorem.com/product/woocommerce-advanced-shipment-tracking/?utm_source=wp-admin&utm_medium=ast-pro&utm_campaign=add-ons',
		'image' => 'ast.png',
		'width' => '140px',
		'file' => 'ast-pro/ast-pro.php'
	),
	1 => array(
		'title' => 'TrackShip for WooCommerce',
		'description' => 'Take control of your post-shipping workflows, reduce time spent on customer service and provide a superior post-purchase experience to your customers.Beyond automatic shipment tracking, TrackShip brings a branded tracking experience into your store, integrates into your workflow, and takes care of all the touch points with your customers after shipping.',
		'url' => 'https://wordpress.org/plugins/trackship-for-woocommerce/?utm_source=wp-admin&utm_medium=ts4wc&utm_campaign=add-ons',
		'image' => 'trackship-logo.png',
		'width' => '140px',
		'file' => 'trackship-for-woocommerce/trackship-for-woocommerce.php'
	),
	2 => array(
		'title' => 'SMS for WooCommerce',
		'description' => 'Keep your customers informed by sending them automated SMS text messages with order & delivery updates. You can send SMS notifications to customers when the order status is updated or when the shipment is out for delivery and more…',
		'url' => 'https://www.zorem.com/products/sms-for-woocommerce/?utm_source=wp-admin&utm_medium=SMSWOO&utm_campaign=add-ons',
		'image' => 'sms-product-icon.png',
		'width' => '90px',
		'file' => 'sms-for-woocommerce/sms-for-woocommerce.php'
	),
	3 => array(
		'title' => 'Advanced Local Pickup',
		'description' => 'The Advanced Local Pickup (ALP) helps you manage the local pickup orders workflow more conveniently by extending the WooCommerce Local Pickup shipping method. The Pro you set up multiple pickup locations, , split the business hours, apply discounts by pickup location, display local pickup message on the products pages, allow customers to choose pickup location per product, force products to be local pickup only and more…',
		'url' => 'https://www.zorem.com/product/advanced-local-pickup-pro/?utm_source=wp-admin&utm_medium=SMSWOO&utm_campaign=add-ons',
		'image' => 'alp.png',
		'width' => '60px',
		'file' => 'advanced-local-pickup-pro/advanced-local-pickup-pro.php'
	),
	4 => array(
		'title' => 'Email Reports for WooCommerce',
		'description' => 'The Sales Report Email Pro will help know how well your store is performing and how your products are selling by sending you a daily, weekly, or monthly sales report by email, directly from your WooCommerce store.',
		'url' => 'https://www.zorem.com/product/email-reports-for-woocommerce/',
		'image' => 'erw.png',
		'width' => '60px',
		'file' => 'sales-report-email-pro/sales-report-email-pro.php'
	),
	5 => array(
		'title' => 'Country Based Restrictions Pro',
		'description' => 'The country-based restrictions plugin by zorem works by the WooCommerce Geolocation or the shipping country added by the customer and allows you to restrict products on your store to sell or not to sell to specific countries.',
		'url' => 'https://www.zorem.com/products/country-based-restriction-pro/?utm_source=wp-admin&utm_medium=CBR&utm_campaign=add-ons',
		'image' => 'cbr.png',
		'width' => '70px',
		'file' => 'country-based-restriction-pro-addon/country-based-restriction-pro-addon.php'
	),	
); 

?>
<section id="cev_content_addons" class="cev_tab_section">
	<div class="tab_container_without_bg_1000">
		<h2 class="tab_page_heading"><?php esc_html_e( 'License', 'customer-email-verification' ); ?></h2>	
		<?php
		/*
		* $license object
		*/
		$license = cev_pro()->license;
		?>

		<div class="license_connection_section">

		<?php 
		$zorem_license_connected = get_option( 'zorem_license_connected', 0 );
		$zorem_license_email = get_option( 'zorem_license_email', '' );
		$current_url = esc_url( admin_url( '/admin.php?page=customer-email-verification-for-woocommerce&tab=add-ons' ) ); 

		if ( $license->get_license_status() ) {
			?>
			<h3 class="licnese-inner-heading"><?php esc_html_e( 'Status:', 'customer-email-verification' ); ?><span class="success">Active</span></h3>
			<p><?php esc_html_e('Want to deactivate the license for any reason?', 'customer-email-verification'); ?></p>
			<form method="post" id="wc_cev_pro_addons_form" class="addons_inner_container" action="" enctype="multipart/form-data">
				<input type="hidden" name="license_key" id="license_key" value="<?php echo esc_attr( $license->get_license_key() ); ?>">
				<?php wp_nonce_field( 'wc_cev_addons_form', 'wc_cev_addons_form_nonce' ); ?>
				<input type="hidden" id="cev-pro-license-action" name="action" value="<?php echo $license->get_license_status() ? esc_html( $license->get_item_code() ) . '_license_deactivate' : esc_html( $license->get_item_code() ) . '_license_activate'; ?>" />
				<button name="save" class="button-primary woocommerce-save-button btn_green_cev" type="submit" value="Deactivate"><?php esc_html_e('Deactivate', 'customer-email-verification'); ?></button>
			</form>	
			<?php
		} else if ( 1 == $zorem_license_connected && '' != $zorem_license_email ) {
			?>
			<h3 class="licnese-inner-heading"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></h3>
			<p><?php esc_html_e('Activate your license to receive automatic updates and premium support', 'customer-email-verification'); ?></p>
			<a href="https://www.zorem.com/my-account/license-activation/?product_id=<?php esc_html_e( $license->get_product_id() ); ?>&redirect_url=<?php echo urlencode( $current_url ); ?>" class="button-primary woocommerce-save-button btn_cev"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></a>
			<?php
		} else {	
			?>
			<h3 class="licnese-inner-heading"><?php esc_html_e( 'Activate License', 'customer-email-verification' ); ?></h3>
			<p><?php esc_html_e('Activate your license to receive automatic updates and premium support.', 'customer-email-verification'); ?></p>
			<a href="https://www.zorem.com/my-account/license-activation/?product_id=<?php esc_html_e( $license->get_product_id() ); ?>&redirect_url=<?php echo urlencode( $current_url ); ?>" class="button-primary woocommerce-save-button btn_cev"><?php esc_html_e( 'Connect & Activate', 'customer-email-verification' ); ?></a>
			<?php
		}
		?>
		</div>			
	</div>
	<div class="d_table" style="">	        	
		<section id="content_tab_addons" class="">         	
			<?php do_action('cev_license_tab_content_data_array'); ?>
			<div class="tab_container_without_bg">
				<h1 class="tab_section_heading clear_spacing" style="margin: 20px 0 0;padding: 0;">Other Products by zorem</h1>
				<div class="plugins_section free_plugin_section">					
					<?php foreach ( $more_plugins as $mplugin ) { ?>
						<div class="single_plugin as-col-4">
							<div class="free_plugin_inner">
								<div class="paid_plugin_image">
									<img src="<?php echo esc_url( cev_pro()->plugin_dir_url() ); ?>assets/images/<?php esc_html_e( $mplugin['image'] ); ?>"?<?php esc_html_e( time() ); ?>>
									<h3 class="plugin_title"><?php esc_html_e( $mplugin['title'] ); ?></h3>
								</div>
								<div class="paid_plugin_description">

									<p><?php esc_html_e( $mplugin['description'] ); ?></p>
									<?php 
									if ( is_plugin_active( $mplugin['file'] ) ) {
										?>
									<button type="button" class="button button button-primary btn_green_cev">Active</button>
								<?php } else { ?>
									<a href="<?php esc_html_e( $mplugin['url'] ); ?>" class="button button-primary btn_cev2" target="blank">More Info</a>
								<?php } ?>								
								</div>
							</div>	
						</div>	
					<?php } ?>					
				</div>					
			</div>
		</section>						
	</div>
</section>
